<?php
/* --------------------------------------------------------------
   TrackingCodeApiServiceProvider.php 2020-04-09
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2020 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

declare(strict_types=1);

namespace Gambio\Api\TrackingCode;

use Gambio\Admin\TrackingCode\Interfaces\TrackingCodeService;
use Gambio\Api\TrackingCode\Actions\CreateTrackingCodesAction;
use Gambio\Api\TrackingCode\Actions\DeleteTrackingCodesAction;
use Gambio\Api\TrackingCode\Actions\FetchAllTrackingCodesAction;
use Gambio\Api\TrackingCode\Actions\FetchSpecificTrackingCodeAction;
use Gambio\Api\TrackingCode\Actions\UpdateTrackingCodesAction;
use Gambio\Core\Application\ServiceProviders\Abstraction\AbstractServiceProvider;

/**
 * Class TrackingCodeApiServiceProvider
 *
 * @package Gambio\Api\TrackingCode
 * @codeCoverageIgnore
 */
class TrackingCodeApiServiceProvider extends AbstractServiceProvider
{
    /**
     * @inheritDoc
     */
    public function provides(): array
    {
        return [
            CreateTrackingCodesAction::class,
            DeleteTrackingCodesAction::class,
            FetchSpecificTrackingCodeAction::class,
            FetchAllTrackingCodesAction::class,
            UpdateTrackingCodesAction::class,
        ];
    }
    
    
    /**
     * @inheritDoc
     */
    public function register(): void
    {
        $this->application->add(TrackingCodeApiRequestParser::class);
        
        $this->application->add(TrackingCodeApiRequestValidator::class);
        
        $this->application->share(CreateTrackingCodesAction::class)
            ->addArgument(TrackingCodeApiRequestParser::class)
            ->addArgument(TrackingCodeApiRequestValidator::class)
            ->addArgument(TrackingCodeService::class);
        
        $this->application->share(DeleteTrackingCodesAction::class)->addArgument(TrackingCodeService::class);
        
        $this->application->share(FetchSpecificTrackingCodeAction::class)->addArgument(TrackingCodeService::class);
        
        $this->application->share(FetchAllTrackingCodesAction::class)
            ->addArgument(TrackingCodeApiRequestParser::class)
            ->addArgument(TrackingCodeService::class);
        
        $this->application->share(UpdateTrackingCodesAction::class)
            ->addArgument(TrackingCodeApiRequestValidator::class)
            ->addArgument(TrackingCodeService::class);
    }
}